#ifndef JOUEUR_H
#define JOUEUR_H

#include "ganah engine.h"
#include "chaine.h"

extern GanahEngine *g_pJeu;
extern char *g_szNomJoueur;
extern char szTemp[10][100];

struct Touche
{
    int m_iHaut;
    int m_iBas;
    int m_iGauche;
    int m_iDroite;
    int m_iBrique;
    int m_iTaper;
    int m_iSauter;
};

class Joueur : public Entite
{
    private:
        int m_iScore;
        int m_iNiveauFurie;
        int m_iCptBrique;
        bool m_bBrique;
        bool m_bGagnant;
        bool m_bTouche;
        bool m_bFurie;
        int m_iNumJoueur;
        
        // Rglages pour le mode normal
        static int m_iForceTaperX,m_iForceTaperY;
        static int m_iStun;
        static int m_iForceSaut;
        static int m_iForceMarcher;
        static int m_iTempsPosage;
        static int m_iCoeffSaut;

        // Rglages pour le mode furie
        static int m_iTempsFurie;
        static int m_iGainFurieTaper;
        static int m_iGainFuriePoser;
        static int m_iGainFurieCasser;
        static int m_iFurieForceTaperX,m_iFurieForceTaperY;
        static int m_iFurieStun;
        static int m_iFurieForceSaut;
        static int m_iFurieForceMarcher;
        static int m_iFurieTempsPosage;
        
        int m_iToucheHaut,m_iToucheBas,m_iToucheGauche,m_iToucheDroite,m_iToucheBrique;
    public:
        Joueur(char *szNom,const int iGauche,const int iDroite,
               const int iBrique,const int iTaper,const int iSauter, int iNumJoueur, bool bLocal);
        Joueur(char *szNom, int iNumJoueur, bool bLocal);
        
        void allerADroite();
        void allerAGauche();
        void sauter();
        void poserBrique();
        void activerFurie();
        void taper();
        void toucher();

        void init();
        
        static void initValeurs();
        
        void setToucheHaut(const int iTouche) { m_iToucheHaut=iTouche ; }
        void setToucheBas(const int iTouche) { m_iToucheBas=iTouche ; }
        void setToucheGauche(const int iTouche) { m_iToucheGauche=iTouche ; }
        void setToucheDroite(const int iTouche) { m_iToucheDroite=iTouche ; }
        void setToucheBrique(const int iTouche) { m_iToucheBrique=iTouche ; }
        
        int getToucheHaut() const { return m_iToucheHaut; }
        int getToucheBas() const { return m_iToucheBas; }
        int getToucheGauche() const { return m_iToucheGauche; }
        int getToucheDroite() const { return m_iToucheDroite; }
        int getToucheBrique() const { return m_iToucheBrique; }
        int getScore() const { return m_iScore ; }
        int getNiveauFurie() const { return m_iNiveauFurie ; }
        int getNumJoueur() const { return m_iNumJoueur ; }
                        
        void updateMarcher();
        void updateBrique();
        void updateTaper();
        void updatePorte();
        void updateToucher();
        void updateFurie();
};

#endif
